/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.bootstrap;

import com.jetbrains.launcher.ApplicationFacadeAdapter2;
import com.jetbrains.launcher.ConfiguringService;
import com.jetbrains.launcher.RunningService;
import com.jetbrains.launcher.contexts.ApplicationContext;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class Bundle
extends ApplicationFacadeAdapter2 {
    private final EntryPointProvider myEntryPointProvider = new EntryPointProvider();

    @NotNull
    public ConfiguringService createConfiguringService(@NotNull ApplicationContext context) {
        return (ConfiguringService)this.myEntryPointProvider.getBundleEntryPoint(context);
    }

    @NotNull
    public RunningService createRunningService(@NotNull ApplicationContext context) {
        return (RunningService)this.myEntryPointProvider.getBundleEntryPoint(context);
    }

    @NotNull
    public static URLClassLoader getClassLoader(@NotNull File[] libDir, ClassLoader parent) {
        ArrayList<File> files = new ArrayList<File>();
        for (File dir : libDir) {
            File[] lfiles = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(@NotNull File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar");
                }
            });
            if (lfiles == null) continue;
            files.addAll(Arrays.asList(lfiles));
        }
        URL[] urls = new URL[files.size()];
        int i = 0;
        for (File file : files) {
            try {
                urls[i] = file.toURI().toURL();
                ++i;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Can not initialize Bundle's class loader", e);
            }
        }
        return new URLClassLoader(urls, parent);
    }

    private class EntryPointProvider {
        private volatile Object delegate;
        private final Object monitor = new Object();

        private EntryPointProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getBundleEntryPoint(@NotNull ApplicationContext ctx) {
            if (this.delegate == null) {
                Object object = this.monitor;
                synchronized (object) {
                    if (this.delegate == null) {
                        Object bundleImpl;
                        URLClassLoader extraBundleClassLoader = Bundle.getClassLoader(new File[]{ctx.getAppFiles().getBaseFiles().getAppHome().toPath().resolve("lib").resolve("ext").toFile()}, Bundle.class.getClassLoader());
                        try {
                            bundleImpl = Class.forName("com.jetbrains.bundle.BundleMain", true, extraBundleClassLoader).getConstructor(ApplicationContext.class).newInstance(ctx);
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException e) {
                            throw new RuntimeException("Can not initialize Bundle", e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException("Can not initialize Bundle", e.getCause() != null ? e.getCause() : e);
                        }
                        this.delegate = Proxy.newProxyInstance(extraBundleClassLoader, new Class[]{ConfiguringService.class, RunningService.class}, new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                                try {
                                    Thread.currentThread().setContextClassLoader(bundleImpl.getClass().getClassLoader());
                                    Object object = method.invoke(bundleImpl, args);
                                    return object;
                                }
                                catch (InvocationTargetException e) {
                                    throw e.getCause() != null ? e.getCause() : e;
                                }
                                finally {
                                    Thread.currentThread().setContextClassLoader(classLoader);
                                }
                            }
                        });
                    }
                }
            }
            return this.delegate;
        }
    }
}

