/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.api.internal.awc.ext.model.migration;

import org.jetbrains.annotations.NotNull;

public enum MigrationStatusEnum {
    STARTING("starting", 1),
    SWITCH_TO_READ_ONLY_MODE("switchToReadOnly", 10),
    BACKUP("backup", 20),
    UPLOAD("upload", 30),
    IMPORT_DONE("done", 40),
    APPLY_EXTERNAL_HUB("applyExternalHub", 50),
    APPLIED("applied", 60),
    SWITCH_TO_READ_ONLY_MODE_FAILED("switchToReadOnly-failed", 10000),
    BACKUP_FAILED("backup-failed", 10001),
    UPLOAD_FAILED("upload-failed", 10002),
    APPLY_EXTERNAL_HUB_FAILED("applyExternalHub-failed", 10003),
    OOM_FAILED("out-of-memory-failed", 10004);

    private final String value;
    private final int order;

    private MigrationStatusEnum(String value, int order) {
        this.value = value;
        this.order = order;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isGreaterThan(@NotNull MigrationStatusEnum other) {
        return this.order > other.order;
    }

    public boolean isLesserThan(@NotNull MigrationStatusEnum other) {
        return this.order < other.order;
    }

    public static MigrationStatusEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        for (MigrationStatusEnum status : MigrationStatusEnum.values()) {
            if (!status.getValue().equals(value)) continue;
            return status;
        }
        throw new IllegalArgumentException(String.format("unknown migration status %s", new Object[0]));
    }
}

