/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.api.internal.awc.ext.model;

import java.util.Collections;
import java.util.Map;

public class HubSettings {
    private final String url;
    private final String internalUrl;
    private final String serviceId;
    private final String serviceSecret;
    private final boolean isInternal;
    private final boolean isRunning;
    private final boolean isInternalHubExists;
    private final boolean isRelinkToExternalHubAllowed;
    private final Map<String, String> myHubServicesWithSecrets;

    public HubSettings(String url, String internalUrl, String serviceId, String serviceSecret, boolean isInternal, boolean isRunning, boolean isInternalHubExists, boolean isRelinkToExternalHubAllowed, Map<String, String> hubServicesWithSecrets) {
        this.url = url;
        this.internalUrl = internalUrl;
        this.serviceId = serviceId;
        this.serviceSecret = serviceSecret;
        this.isInternal = isInternal;
        this.isRunning = isRunning;
        this.isInternalHubExists = isInternalHubExists;
        this.isRelinkToExternalHubAllowed = isRelinkToExternalHubAllowed;
        this.myHubServicesWithSecrets = hubServicesWithSecrets;
    }

    public String getUrl() {
        return this.url;
    }

    public String getInternalUrl() {
        if (this.internalUrl == null) {
            return this.getUrl();
        }
        return this.internalUrl;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getServiceSecret() {
        return this.serviceSecret;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isInternalHubExists() {
        return this.isInternalHubExists;
    }

    public boolean isRelinkToExternalHubAllowed() {
        return this.isRelinkToExternalHubAllowed;
    }

    public Map<String, String> getHubServicesWithSecrets() {
        return Collections.unmodifiableMap(this.myHubServicesWithSecrets);
    }
}

